<?php
/* --------------------------------------------------------------
   FetchAllWithdrawalsAction.php 2020-04-09
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Api\Withdrawal\Actions;

use Gambio\Admin\Withdrawal\Interfaces\WithdrawalService;
use Gambio\Api\Application\Responses\CreateApiMetaDataTrait;
use Gambio\Api\Application\Responses\ResponseDataTrimmerTrait;
use Gambio\Api\Withdrawal\WithdrawalApiRequestParser;
use Slim\Http\Response;
use Slim\Http\ServerRequest as Request;

/**
 * Class FetchAllWithdrawalsAction
 *
 * @package Gambio\Api\Withdrawal\Actions
 */
class FetchAllWithdrawalsAction
{
    use CreateApiMetaDataTrait;
    use ResponseDataTrimmerTrait;
    
    /**
     * @var WithdrawalApiRequestParser
     */
    private $requestParser;
    
    /**
     * @var WithdrawalService
     */
    private $service;
    
    
    /**
     * FetchAllWithdrawalsAction constructor.
     *
     * @param WithdrawalApiRequestParser $requestParser
     * @param WithdrawalService          $service
     */
    public function __construct(
        WithdrawalApiRequestParser $requestParser,
        WithdrawalService $service
    ) {
        $this->requestParser = $requestParser;
        $this->service       = $service;
    }
    
    
    /**
     * @param Request  $request
     * @param Response $response
     * @param array    $args
     *
     * @return Response
     */
    public function __invoke(Request $request, Response $response, array $args): Response
    {
        $criteria = $this->requestParser->getCriteriaFromRequest($request);
        $fields   = $this->requestParser->getFieldsFromRequest($request);
        
        $withdrawals = $this->service->getAllWithdrawals($criteria,
                                                         $this->requestParser->getPaginationFromRequest($request));
        $totalItems  = $this->service->getTotalCountOfWithdrawals($criteria);
        $metaData    = $this->createApiCollectionMetaData($this->requestParser->getPageFromRequest($request),
                                                          $this->requestParser->getPerPageFromRequest($request),
                                                          $totalItems,
                                                          $this->requestParser->getResourceUrlFromRequest($request),
                                                          $request->getQueryParams());
        
        $responseData = $withdrawals;
        if (count($fields) > 0) {
            $collectionData = json_decode(json_encode($withdrawals), true);
            $responseData   = $this->trimCollectionData($collectionData, $fields);
        }
        
        return $response->withJson([
                                       'data'  => $responseData,
                                       '_meta' => $metaData,
                                   ]);
    }
}